#ifndef COMMUNICATIONCONTROLLER_H_
#define COMMUNICATIONCONTROLLER_H_

#include "AgentFactory.h"
#include "CommunicationSender.h"
#include "IAgent.h"
#include "../Configuration/ConfigurationServer.h"
#include "../DataTypes/DataAgent.h"
#include <list.h>
#include <time.h>
#include <sys/time.h>
#include <sys/timeb.h>

using namespace std;
using namespace DataTypes;
using namespace Configuration;
namespace Communication
{

class CommunicationController
{  
public:
	CommunicationController();
	virtual ~CommunicationController();
	list <IAgent *> GetAgents();
	void FreeResources();
	void AddAgent(DataAgent *data);
	
	bool ExistsAgent(string key);
	void SynchronizeAgent(string key, int iteration);
	void ResetSynchronization(int iteration);
	bool SyncRemaining();
	void AgentInfoRequest(string keyrequester, string keyrequeted);
	void BroadcastMessage(string message);
	void BroadcastResponse(string message);
	void ForwardMessage(string message);
private:
	list <IAgent *> agents;
	CommunicationSender *sender;
};

}

#endif /*COMMUNICATIONCONTROLLER_H_*/
